'==========================================================================
'
' Simple iTunes Interface (VBScript)
' 
' DATE  : 13/12/2005
'
' Format   : iTunes.vbs <command> [<playList> <trackNumber>]
'     
'           
'==========================================================================

Option Explicit

dim iTunesApp, objShell, objArgs, result
set iTunesApp = WScript.CreateObject("iTunes.Application")
Set objShell = WScript.CreateObject("WScript.Shell")
Set objArgs = WScript.Arguments

result = allocateJob()
WScript.StdOut.Write result


Function allocateJob()
 Dim result
 If objArgs(0) = "doPlay" Then
   doPlay()
 Elseif objArgs(0) = "doStop" Then
   doStop()
 Elseif objArgs(0) = "getTracks" Then
   result = getTracks()
 Elseif objArgs(0) = "enumeratePlayLists" Then
   result =enumeratePlayLists()
 elseif objArgs(0) = "getTrackNum" Then
    result = getTrackNum()
 Elseif objArgs(0)= "playRandom" Then
   playRandom() 
   Elseif objArgs(0) = "setShuffle" Then
   setShuffle() 
Elseif objArgs(0) = "getStatus" Then
   result = getStatus()
 Elseif objArgs(0) = "getTrack" Then
   result = getTrack()
   Elseif objArgs(0) = "getArtist" Then
   result = getArtist()
 End If
 allocateJob = result
End Function


Function enumeratePlayLists()
Dim thePlayLists, Result, i
Set thePlayLists = iTunesApp.LibrarySource.Playlists

For i=1 To thePlayLists.Count
 Result = Result & thePlayLists.Item(i).Name & vbNewLine
Next
enumeratePlayLists = Result
End Function

Sub doPlay()
Dim thePlayLists, theTrack, theLibrary, thePlayList, i

Set theLibrary = iTunesApp.LibrarySource
Set thePlayLists = theLibrary.Playlists
Set thePlayList = thePlayLists.Item(1)


Set thePlayList = thePlayLists.ItemByName(objArgs(1))
If IsNull(thePlayList) Then
 'cant find playlist
 return Null
End If

Set theTrack = thePlayList.Tracks.Item(objArgs(2))
theTrack.Play()
set iTunesApp.CurrentPlaylist.SongRepeat = 2
End Sub

Sub playRandom()
 Dim theLibrary, firstTrack, upperBound, lowerBound
 Set theLibrary = iTunesApp.LibrarySource.Playlists.ItemByName(objArgs(1))
 upperBound = theLibrary.Tracks.Count
 lowerBound = 1
 Randomize
 firstTrack = Int((upperbound - lowerbound + 1) * Rnd + lowerbound)
 theLibrary.Tracks.Item(firstTrack).Play()
End Sub	

Sub setShuffle()
 Dim theLibrary, thePlayList
 set thePlayList = iTunesApp.LibrarySource.Playlists.ItemByName(objArgs(1))
 Set theLibrary = iTunesApp.LibraryPlaylist
 thePlayList.Shuffle = objArgs(2)
 thePlayList.SongRepeat = 2
 iTunesApp.Windows.Item(1).Minimized = true
 objShell.AppActivate("Ten Thumbs Typing Tutor")
End Sub

Sub doStop()
iTunesApp.Windows.Item(1).Minimized = True
iTunesApp.Stop
objShell.AppActivate("Ten Thumbs Typing Tutor")
End Sub

Function getTracks()
Dim Result, thePlayLists, thePlayList, theTracks, theTrack, i
Set thePlayLists = iTunesApp.LibrarySource.Playlists
Set thePlayList = thePlayLists.ItemByName(objArgs(1))
Set theTracks = thePlayList.Tracks	
For i=1 To theTracks.Count
 Set theTrack = theTracks.Item(i)
 Result = Result & theTrack.Artist & " - " & theTrack.Name & " - " & theTrack.Duration & vbNewLine
Next

getTracks = Result
End Function

Function getTrackNum()
 Dim Result, thePlayList, theTrack, theState, x
 Set thePlayList = iTunesApp.CurrentPlaylist
 theState = iTunesApp.PlayerState
 Result = 0
 If theState <> 1 Then
 getTrackNum = Result
 End If

 theTrack = iTunesApp.CurrentTrack.TrackID

 For x=1 To thePlayList.Tracks.Count 
  If thePlayList.Tracks(x).TrackID = theTrack Then
    Result = x
    Exit For
  End If
 next  
 getTrackNum = Result
 End Function
 
Function getStatus()
Dim tTrack, tPlaylist, tStatus, tShuffle, tPosition
tTrack = iTunesApp.CurrentTrack.Artist & " | " & iTunesApp.CurrentTrack.Name & " | " & iTunesApp.CurrentTrack.Duration
tStatus = iTunesApp.PlayerState
tPlaylist = iTunesApp.CurrentPlaylist.Name
tPosition = iTunesApp.PlayerPosition
tShuffle = iTunesApp.CurrentPlaylist.Shuffle
getStatus = tPlaylist & "%" & tTrack & "%" & tStatus & "%" & tShuffle & "%" & tPosition
End Function

Function getArtist()
Dim tArtist
tArtist = ""
iTunesApp.Windows.Item(1).Minimized = True
getArtist = cStr(iTunesApp.CurrentTrack.Artist)
End Function

Function getTrack()
Dim tTrack
tTrack = ""
iTunesApp.Windows.Item(1).Minimized = True
getTrack = cStr(iTunesApp.CurrentTrack.Name)
End Function



